#!/usr/bin/env python

#
# Installer for Models@Home
#
# License: Public Domain

import string,os,shutil,fnmatch,crypt

# CREATE DIRECTORY LISTING INCLUDING FULL PATH NAMES
# ==================================================
def dsc_dirlist(path):
  # NORMALIZE PATH, IMPORTANT TO CONVERT UNIX FORWARD TO WINDOWS BACKWARD SLASHES
  path=os.path.normpath(os.path.normcase(path))
  # CREATE LIST OF ALL THE FILENAMES IN THE DIRECTORY SPECIFIED BY PATH
  (path,wildcard)=os.path.split(path)
  if (path==""): path="."
  try: filelist=os.listdir(path)
  except: return(None)
  # CYCLE THROUGH ALL FILES AND CHECK IF THEY MATCH WILDCARD
  i=0
  while (i<len(filelist)):
    if (fnmatch.fnmatch(filelist[i],wildcard)):
      filelist[i]=os.path.join(path,filelist[i])
      if (os.path.isfile(filelist[i])):
        i=i+1
        continue
    # NO MATCH
    del filelist[i]
  filelist.sort()
  return(filelist)

# MAIN SCRIPT
# ===========
print
print "Welcome to the Models@Home installer"
print "===================================="
print
print "More information available at www.yasara.org/models"
print "This installer has been tested with RedHat 8.0,9.0 and Fedora 1.0," 
print "but should work with most other Linux distributions."
print
password="YourPassword"
xsetupfilename="/etc/X11/xdm/Xsetup_0"
xsessionfilename="/etc/X11/xdm/Xsession"
xscrsaverfilename="/usr/lib/X11/app-defaults/XScreenSaver"

# MODIFY Xsetup_0
if (os.path.exists(xsetupfilename+".backup")):
  print "Xsetup has already been adapted previously"
else:
  print "Installing new Xsetup file..."
  shutil.copy(xsetupfilename,xsetupfilename+".backup")
  xsetup=open(xsetupfilename).readlines()
  i=0
  while (i<len(xsetup)):
    line=xsetup[i]
    if ((string.find(line,"xsri")!=-1 and string.find(line,"if ")==-1) or
        string.find(line,"xsetroot")!=-1):
      xsetup[i]="# Line removed by Models@Home installer: "+xsetup[i]
      if (string.find(line,"xsetroot")!=-1):
        insertion=['/usr/X11R6/bin/xsetroot -solid "#356390"\n',
                   '# Display CMBI Models@Home Logo\n',
                   'if [ -x /usr/bin/xsri ]; then\n',
                   '   /usr/bin/xsri -keep-aspect /usr/cluster/clulogin.png\n',
                   'fi\n',
                   '# Disable screen saver\n',
                   '/usr/cluster/scrsavco -exit 1>/usr/cluster/com.txt 2>/usr/cluster/com.err\n',
                   '# If a new program is available, replace the old one\n',
                   'chown -R models.athome /usr/cluster\n',
                   'if [ -e /usr/cluster/cluster.new ]; then\n',
                   '  cp /usr/cluster/cluster.new /usr/cluster/cluster\n',
                   '  chmod 700 /usr/cluster/cluster\n',
                   'fi\n',
                   '# Enable screen saver\n',
                   '/usr/cluster/scrsaver -timeout 5 1>/usr/cluster/sav.txt 2>/usr/cluster/sav.err &\n']
        xsetup=xsetup[:i+1]+insertion+xsetup[i+1:]
        i=i+len(insertion)
    i=i+1
  open(xsetupfilename,"w").writelines(xsetup)

# MODIFY Xsession
if (os.path.exists(xsessionfilename+".backup")):
  print "Xsession has already been adapted previously"
else:
  print "Installing new Xsession file..."
  shutil.copy(xsessionfilename,xsessionfilename+".backup")
  xsession=open(xsessionfilename).readlines()
  xsession=[xsession[0]]+["# Stop Models@Home screen saver\n","/usr/cluster/scrsavco -exit\n"]+xsession[1:]
  open(xsessionfilename,"w").writelines(xsession)

# MODIFY Xscrsaver
if (os.path.exists(xscrsaverfilename+".backup")):
  print "Xscrsaver has already been adapted previously"
else:
  print "Installing new Xscrsaver file..."
  shutil.copy(xscrsaverfilename,xscrsaverfilename+".backup")
  xscrsaver=open(xscrsaverfilename).readlines()
  i=0
  while (i<len(xscrsaver)):
    line=xscrsaver[i]
    if (line[:8]=="*timeout"): line="*timeout 0:05:00\n"
    if (line[:6]=="*cycle"): line="*cycle 0:00:00\n"
    if (line[:7]=="*splash"): line="*splash False\n"
    if (line[:9]=="*programs"):
      line="*programs:	/usr/cluster/cluster -cli -cd/usr/cluster\\n\n"
      j=i
      while (string.strip(xscrsaver[j])!=""): j=j+1
      xscrsaver=xscrsaver[:i+1]+xscrsaver[j:]
    xscrsaver[i]=line
    i=i+1
  open(xscrsaverfilename,"w").writelines(xscrsaver)

# CHECK IF libncurses.so.5 IS PRESENT
liblist=dsc_dirlist("/usr/lib/libncurses.so.*")
for lib in liblist:
  if (string.find(lib,"libncurses.so.5")!=-1): break
else:
  os.system("ln -s libncurses.so.5 "+liblist[0])

# CHECK IF SDL LIBRARY IS PRESENT (GET FROM www.libsdl.org)
print "Checking libraries..."
liblist=dsc_dirlist("/usr/lib/libSDL-1.2*")
if (liblist==[]): shutil.copy("libSDL-1.2.so.0","/usr/lib/libSDL-1.2.so.0")
liblist=dsc_dirlist("/usr/lib/libSDL_image-1.2*")
if (liblist==[]): shutil.copy("libSDL_image-1.2.so.0","/usr/lib/libSDL_image-1.2.so.0")
liblist=dsc_dirlist("/usr/lib/libSDL_net-1.2*")
if (liblist==[]): shutil.copy("libSDL_net-1.2.so.0","/usr/lib/libSDL_net-1.2.so.0")

# CHECK IF xsri IS PRESENT
if (not os.path.exists("/usr/bin/xsri")): shutil.copy("xsri","/usr/bin/xsri")


# CREATE athome GROUP
group=open("/etc/group").read()
if (string.find(group,"athome")!=-1):
  print "Group athome already defined"
else:
  print "Creating new group 'athome'"
  os.system("/usr/sbin/groupadd -g 38475 athome")

# CREATE NEW MODELS@HOME USER
passwd=open("/etc/passwd").read()
if (string.find(passwd,"Models@Home")!=-1):
  print "User models already defined"
else:
  print "Creating new user 'models'"
  cryptpwd=crypt.crypt(password,"Mo")
  print "Encrypted password is ",cryptpwd
  os.system("/usr/sbin/useradd -c Models@Home -d /usr/cluster -g 38475 -M -n -p "+cryptpwd+" -u 38475 models")

# CHANGE OWNER OF /usr/cluster
os.system("chown -R models.athome /usr/cluster")
os.system("chmod -R ug+w /usr/cluster")
print "Installation completed successfully."
