/**********************************************************
 *                                                        *
 *                LONELY? WANNA HAVE FUN?                 *
 *                                                        *
 *               DO YOURSELF A FAVOUR - GET               *
 *                                                        *
 *                 M O D E L S @ H O M E                  *
 *                                                        *
 *                  THE WORLDWIDEWEBBED                   *
 *            C M B I _ M O D E L S E R V I C E           *
 *                                                        *
 **********************************************************
 *            Written in 2000 by Elmar Krieger            *
 * CMBI,Center for Molecular and Biomolecular Informatics *
 *        Katholic University Nijmegen, Netherlands       *
 **********************************************************
 *       This is the Windows screensaver source code      *
 **********************************************************
 * Search for "chdrive" to find the place where the true  *
 *  cluster software (cluster.exe) is run. If you cannot  *
 * use directory c:\cluster, then make your changes there.*
 **********************************************************
 * Today was really a lucky day: This whole thing, con-   *
 * sisting entirely of code collected in the web, cross-  *
 * compiled under Linux for Windows easily, worked really *
 * instantly and did exactly what it was expected to. So  *
 * I'll better go home now before something terrible      *
 * happens... (No attempt was made to clean it up, so the *
 * whole thing is a mess. It is as "free" as code can be, *
 * do whatever you want, but do not sue me afterwards ;-) *
 **********************************************************/
#define SCR_WINTITLE "MODELS@HOME - The CMBI Modelservice"
#define LOCKFILE "c:\\cluster\\cluster.lok"


#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>
/* --------------------------------------------------------------------

    VGAFAN - A Random Color Serpent Fan Windows Screen Saver

    (C) Copyright Bill Buckels 1997.
    All Rights Reserved.

    with the exception of Portions of this code which are
    (C) Copyright Microsoft Corp. 1991.  All rights reserved.

    You have a royalty-free right to use, modify, reproduce and
    distribute the Sample Files (and/or any modified version) in any way
    you find useful, provided that you agree that neither Microsoft
    nor Bill Buckels has no warranty obligations or liability for any
    Sample Application Files which are modified.

    The Algorithm used in this program is loosely based on ART.PAS (ART
    Demonstration Program Version 1.00A 03-18-85) which was shipped with
    Turbo Pascal Version 3.00 for the IBM PC (Author Unknown). No
    credits or Copyright notices appear in the source code for ART.PAS.

    DESCRIPTION

    This program creates a Color Serpent Fan on a black background which
      bounces-off the sides of the viewport, and changes color and shape
      randomly.

    The color fan can contain up to 400 lines of "Serpent Length".
      (this is a user-definable setting)

    Before a new line is drawn, the oldest line in the fan is redrawn
      in black, which effectively erases the "tail" of the serpent
      fan and "cross-hatches" over-top of any line segments that
      share the same area on the screen.

    This creates a 3d effect, and since it is far too computationally
      intensive to calculate shared space, it is a moot point whether we
      would want to sacrifice animation speed to offer an alternate
      method of line removal to the currently implemented erase by redraw.

    By erasing the oldest line in the fan, we keep the screen from
      becoming too cluttered and eventually filling-up with broken
      lines.

    SETTINGS

    Setting-Up VGAFan is done from the Windows Control panel.
      A modest number of settings is available.

    Settings are stored in CONTROL.INI and are saved between
      Windows sessions. This is convenient unless you forget
      your password when you have password enabled.

    Password Settings

    The Screen Saver Password is set from The Windows Control Panel
      by selecting the VGAFan as your screen saver and checking the
      checkbox for the password.

    Make sure you remember your password if you use this feature.

    Other Settings

    Besides the usual Windows Password Settings, VGAFan has 4 animation
      settings that are accessed from the Windows Control Panel. These
      allow user parameters within range to control the appearance and
      behaviour of the fan animation.

    Speed

    The speed control sets a dwell time value in milliseconds from 1
      to ???? (fast to slow) between lines.

    This value is a simple setting and used for a timer callback. The
      method is admittedly not very elegant but simple and effective.

    The default setting for drawspeed is 5 ms between lines. Making this
      into too short an interval may prevent slower computers from
      other processing. Making this setting too high slows the
      fan down too much.

    Combining this setting with number of lines controls the
      overall drawspeed.

    Serpent Length

    The serpent length parameter allows the setting of from 100 - 400
      lines in the fan. When the setting is changed, the previous
      fan is cleared.

    By default this setting is 300.

    Contrast

    The contrast setting is from 0 - 100.  0 contrast gives you
      colors with the sharpest contrast. 100 gives you colors that
      are softer and more grayed.

    Regardless of contrast, the random color selection in VGAFan
      attempts to build colors that are not completely flat and gray.

    The Default setting for contrast is 0. This is the sharpest
      setting.

    Number of Lines

    The setting for number of lines is used to gain some additional
      performance by drawing lines in groups between timer callbacks.

    If this setting is too high and the speed setting is too low
      the animation may appear jerky or blotchy.

    By default, this setting is 2. It may be varied from 1 - SerpentLength

    ORIGIN

    As noted, I adapted the basic Color Fan concept from an old pascal
      program called ART.PAS (ART DEMONSTRATION PROGRAM) which was
      shipped with Borland Pascal Version 3.00 and ran on a 320 x 200 x
      4 Color CGA display. Needless to say some severe adaptation was
      required.

    There is some resemblance to the pascal program both in strategy
      and in simplicity. The VGAFan is definetely a different
      program but there is only so much you can do with a color fan.

    I was impressed with ART.PAS in my CGA Days, and I felt its basic
      color serpent would make an attractive effort for my first Windows
      screen saver.

    I actually first wrote this screen saver as a module for the
      Windows version of Berkley After Dark, which I found to be just as
      much work as doing this as a standard screen saver.

    My effort in writing this as a Berkely After Dark module was fun,
      but as a Standard Windows Screen saver you don't need AD to run
      VGAFan. Since it is compatible with Windows 3.1 or Windows 95,
      almost anyone will be able to use it.

    CODE

    The code in this program is pretty well commented and you shouldn't
      have much trouble reading it.

    I used the bouncer screen saver example from the Microsoft Windows 3.1
      SDK, and some of the code is still in place.

    If you use this code as the basis for your own screen saver, you
      should not have much trouble adapting it, but be careful to
      read the comments in scrnsave.h and perhaps the bouncer project
      and don't remove any of the code that Windows expects.

    A screensaver is only an EXE file that is produced using certain
      specific guidelines, and then renamed to a .SCR file.

    In Windows 3.1 these are kept in the Windows directory and in
      Windows 95 they are tossed into the WINDOWS\SYSTEM directory.
      They then become visible in the Control Panel and run exactly
      the same as the screensavers that are shipped with Windows.

    Bill Buckels 1997

  --------------------------------------------------------------------- */

#include <windows.h> 
#include <mmsystem.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <direct.h>
#include "scrsaver.h"

/* Global used by SCRNSAVE.LIB. Required for all screen savers. */

char szAppName[40];

/* Globals specific to VGAFan. */
char szSpeedName[]    = "Speed";
char szLengthName[]   = "Length";
char szContrastName[] = "Contrast";
char szLinesName[]    = "Lines";
char szName[]         = "VGA Serpent Fan";
char szLocalHelp[]    = "vgafan.hlp";

/* Externals defined in SCRNSAVE.LIB. Required for all screen savers.  */

HINSTANCE hMainInstance;
HWND hMainWindow;
char szIsPassword[22];
char szIniFile[MAXFILELEN];
char szScreenSaver[22];
char szPassword[16];
char szDifferentPW[BUFFLEN];
char szChangePW[30];
char szBadOldPW[BUFFLEN];
char szHelpFile[MAXFILELEN];
char szNoHelpMemory[BUFFLEN];
UINT MyHelpMessage;
HOOKPROC fpMessageFilter;

/* ----------------------------------------------------------------------- */
/*   VGAFAN GLOBALS                                                        */
/* ----------------------------------------------------------------------- */
BOOL bHelpActive       = FALSE;
BOOL bLocalActive      = FALSE;
BOOL bGlobalActive     = FALSE;
BOOL bRefresh          = FALSE;
BOOL bTaskActive       = FALSE;
BOOL bQuitRequest      = FALSE;

WORD wTimer            = NIL;             /* timer id                      */
WORD wDrawSpeed        = DRAWSPEED;       /* speed parameter               */
WORD wSerpentLength    = MEMORYMEDIUM;    /* length parameter              */
WORD wContrastFactor   = HIGHCONTRAST;    /* contrast parameter            */
WORD wOldDrawSpeed     = DRAWSPEED;       /* saved speed parameter         */
WORD wOldSerpentLength = MEMORYMEDIUM;    /* saved length parameter        */
WORD wOldColorContrast = HIGHCONTRAST;    /* saved contrast parameter      */
WORD wNumberOfLines    = DEFLINES;        /* minimum number of lines       */
WORD wOldNumberOfLines = DEFLINES;        /* saved minimum number of lines */

BOOL bPassword;                           /* password protected?           */
time_t lWanderTime = 0L;                  /* random number seed var.       */

HDC hDC = NULL;                           /* Handle to our window DC       */
HDC hDCTemp = NULL;
HPEN hBlackPen = NULL;
RECT rcWnd;                               /* Rectangle used for drawing    */

COLORREF DrawColor = 0L;                  /* global color                  */

/* global coordinates used to compute values for animation */
int iLX1 = NIL, iLX2 = NIL, iLY1 = NIL, iLY2 = NIL,
           iCurrentLine = NIL, iColorCount = NIL, iIncrementCount = NIL,
           iDeltaX1 = NIL, iDeltaY1 = NIL, iDeltaX2 = NIL, iDeltaY2 = NIL;


/* a FIFO ring buffer to store line history */
struct {
  int iLX1, iLY1;
  int iLX2, iLY2;
  COLORREF  color;
  } WanderLine[MEMORYMAX];

long dsc_filesize(const char *filename)
{ struct stat file;

  if (stat(filename,&file)==-1) return(0);
  return(file.st_size); }

int dsc_loadfilealloc(char *filename,char **address)
{ int i,size;
  FILE *fb;

  *address=NULL;
  if ((fb=fopen(filename,"rb"))!=NULL)
  { size=dsc_filesize(filename);
    *address=malloc(size);
    i=fread(*address,1,size,fb);
    *address=realloc(*address,i);
    fclose(fb);
    return(i); }
  return(0); }

int dsc_savefile(char *filename,char *address,int length)
{ int i;
  FILE *fp;

  i=0;
  if ((fp=fopen(filename,"wb"))!=NULL)
  { i=fwrite(address,1,length,fp);
    fclose(fp); }
  return(i); }

/* ------------------------------------------------------------------- */
/*                                                                     */
/* ScreenSaverProc - Main entry point for screen saver messages.       */
/*  This function is required for all screen savers.                   */
/*                                                                     */
/* Params:  Standard window message handler parameters.                */
/*                                                                     */
/* Return:  The return value depends on the message.                   */
/*                                                                     */
/*  Note that all messages go to the DefScreenSaverProc(), except      */
/*  for ones we process.                                               */
/* ------------------------------------------------------------------- */
LONG FAR PASCAL ScreenSaverProc(HWND hWnd,UINT msg, WPARAM wParam, LPARAM lParam)
{
  //RECT rc;
  int i;
  char *tmp;
  //FILE *fp;
  //time_t timestamp,currtime;

  //HWND windowid;

  switch (msg) {

    case WM_CREATE:

      bTaskActive   = TRUE;
      bQuitRequest  = FALSE;
      {
        /* Load the strings from the STRINGTABLE */
        GetIniEntries();
        /* Load the initial settings. */
        GetIniSettings();
        /* Initialize and Create an animation timer */
        /* leave enough time to process messages    */
        /* before starting the screensaver...       */
        /* if we don't the background will not be cleared */
        //wTimer = SetTimer(hWnd, ID_TIMER, 50, NULL);

        /* IS A PREVIOUS INSTANCE OF THE SCREENSAVER ALREADY RUNNING? */
        /* FindWindow DOESN'T WORK HERE (WORKS IN OTHER PROGRAMS, NO IDEA WHAT'S THE PROBLEM HERE) */
        //windowid=FindWindow(NULL,SCR_WINTITLE);
        /*timestamp=0;
        fp=fopen(LOCKFILE,"wb");
        if (fp!=NULL)
        { fread(&timestamp,1,sizeof(time_t),fp);
          fclose(fp); }
        time(&currtime);*/
        /* IF TIMESTAMP STORED IN cluster.lok IS OLDER THAN 30 MINUTES, WE
           KNOW THAT NO OTHER SCREENSAVER IS CURRENTLY RUNNING */
        //if (currtime>timestamp+30*60)
        { /* NO */
          _chdrive(3);
          chdir("c:\\cluster");
          /* REPLACE OLD CLUSTER SOFTWARE WITH UPDATED VERSION */
          /* THE SYSTEM COMMAND copy BELOW DOES NOT WORK, SO WE READ AND WRITE
             THE FILE MANUALLY */
          //system("copy c:\\cluster\\cluster.win c:\\cluster\\cluster.exe");
          i=dsc_loadfilealloc("c:\\cluster\\cluster.win",&tmp);
          dsc_savefile("c:\\cluster\\cluster.exe",tmp,i);
          system("c:\\cluster\\cluster.exe -cli"); }
        PostQuitMessage(0); }
      bTaskActive = FALSE;
      break;

    /*
    case WM_TIMER:

      if (bTaskActive == TRUE)
        break;

      bTaskActive = TRUE;


      {
        if (bQuitRequest == FALSE) {
          if (hDC == NULL) {
            KillTimer(hWnd, ID_TIMER);
            hDC = GetDC(hWnd);
            if (hDC != NULL) {
              hBlackPen=CreatePen(PS_SOLID,1, 0L);
              GetClientRect(hWnd, &rcWnd);
              DoBlank(hWnd, FALSE);
            }
            // if we are set below 1ms we still use a 1ms
            //   dwell for our callbacks because the rest of
            //   system needs cycles...
            if (wDrawSpeed < 1)
              wTimer = SetTimer(hWnd, ID_TIMER, 1, NULL);
            else
              wTimer = SetTimer(hWnd, ID_TIMER, wDrawSpeed, NULL);
          }
          else {
            WanderingLines(hWnd);
          }
        }
      }
      bTaskActive = FALSE;
      break;
    */
    case WM_DESTROY:

      bQuitRequest = TRUE;
      /*if(wTimer)
        KillTimer(hWnd, ID_TIMER);
      wTimer = NIL;*/
      /* if we have messed-up the screen make it look nice on our way out */
      /*
      if ((bRefresh = bTaskActive = (BOOL)((bTaskActive == FALSE) &&
           bPassword && (hDC != NULL) && (hBlackPen != NULL))))
        BlankCheck(hWnd);
      bRefresh = bTaskActive = FALSE;
      if(hDC != NULL)
        ReleaseDC(hWnd, hDC);
      if (hBlackPen != NULL)
        DeleteObject(hBlackPen);
      hBlackPen = NULL;
      hDC = NULL;*/
      break;

    case WM_ERASEBKGND:

      /* this is our paint method */

      /* the only time we will need to repaint after intialization */
      /* is when the password is set and the user cancels... */

                             /* if password is set */
      //bRefresh = bPassword;  /* set refresh flag... signal repaint */

      /* we only want to paint the screen black... and set a refresh flag  */
      /*   our drawing routines will redraw before continuing...           */
      /*
      hDCTemp = (HDC)wParam;
      GetClientRect(hWnd,&rc);
      FillRect(hDCTemp,&rc,(HBRUSH)GetStockObject(BLACK_BRUSH));
      */
      return 0L;

    default:
      break;
  }

  return DefScreenSaverProc(hWnd, msg, wParam, lParam);
}


/* ------------------------------------------------------------------- */
/* RegisterDialogClasses -- Entry point for registering window         */
/*  classes required by configuration dialog box.                      */
/* ------------------------------------------------------------------- */
BOOL WINAPI RegisterDialogClasses(HANDLE h)
{
  return TRUE;
}

/* ------------------------------------------------------------------- */
/* ScreenSaverConfigureDialog -- Dialog box function for configuration */
/*  dialog.                                                            */
/* ------------------------------------------------------------------- */
BOOL FAR PASCAL ScreenSaverConfigureDialog(HWND hDlg, UINT msg,
                                           WPARAM wParam, LPARAM lParam)
{
  static HWND hIDOK;
  static HWND hSetPassword;

  switch (msg) {

    case WM_INITDIALOG:

      ConfigInitProc(hDlg);
      hSetPassword=GetDlgItem(hDlg, ID_SETPASSWORD);
      EnableWindow(hSetPassword, bPassword);
      hIDOK=GetDlgItem(hDlg, IDOK);
      return TRUE;

    case WM_COMMAND:

      switch (wParam) {

        case IDOK:
          ConfigOKProc(hDlg);
          EndDialog(hDlg, TRUE);
          return TRUE;

        case IDCANCEL:
          LocalHelpProc(hDlg, (WPARAM)NIL);
          EndDialog(hDlg, FALSE);
          return TRUE;

        case ID_SETPASSWORD:
        {
          //FARPROC fpDialog;

          return FALSE;
          /*
          if ((NULL) ==
              (fpDialog = MakeProcInstance(DlgChangePassword,hMainInstance)))
            return FALSE;
          DialogBox(hMainInstance, MAKEINTRESOURCE(DLG_CHANGEPASSWORD),
                    hDlg, fpDialog);
          FreeProcInstance(fpDialog);
          SendMessage(hDlg, WM_NEXTDLGCTL, (int)hIDOK, 1l);
          break;*/
        }

        case ID_PASSWORDPROTECTED:
          bPassword ^= 1;
          CheckDlgButton(hDlg, wParam, bPassword);
          EnableWindow(hSetPassword, bPassword);
          break;

        case ID_GLOBALHELP:
        case ID_LOCALHELP:
        case ID_CONTEXTHELP:
          LocalHelpProc(hDlg, wParam);
          break;

      }
      break;

    default:
      /* Context Sensitive Help - F1 Was Pressed */
      if (msg == MyHelpMessage)
        LocalHelpProc(hDlg, ID_CONTEXTHELP);
  }
  return FALSE;
}


/* ------------------------------------------------------------------- */
/* Help Handler                                                        */
/* ------------------------------------------------------------------- */
void LocalHelpProc(HWND hDlg, WPARAM wParam)
{
   BOOL bStatus;

   switch (wParam) {
     case ID_CONTEXTHELP:
       bStatus = bHelpActive=WinHelp(hDlg, szLocalHelp, HELP_CONTEXT,
                                                        IDH_MYSETUP);
       break;
     case ID_LOCALHELP:
       bStatus = bHelpActive=WinHelp(hDlg, szLocalHelp, HELP_CONTENTS,
                                                        IDH_MYCONTENTS);
       break;
     case ID_GLOBALHELP:
       bStatus = bGlobalActive = WinHelp(hDlg, szHelpFile, HELP_CONTEXT,
                                              (DWORD)IDH_DLG_CHANGEPASS);
       break;
     default:
       bStatus = TRUE;
       /* if a NIL ID used for this call we are cleaning up */
       /* close any help windows that we have open...       */
       if (bHelpActive == TRUE)
         WinHelp(hDlg, szLocalHelp, HELP_QUIT, IDH_MYSETUP);
       if (bGlobalActive == TRUE)
         WinHelp(hDlg, szLocalHelp, HELP_QUIT, IDH_MYCONTENTS);
       if (bGlobalActive == TRUE)
         WinHelp(hDlg, szHelpFile, HELP_QUIT, (DWORD)IDH_DLG_CHANGEPASS);
       bHelpActive = bLocalActive = bGlobalActive = FALSE;
       break;
  }

  if (!bStatus)
    MessageBox(hDlg, szNoHelpMemory, szName, MB_ICONSTOP|MB_OK);

}

/* ------------------------------------------------------------------- */
/* Initialize dialog so get INI settings and put values in fields      */
/* ------------------------------------------------------------------- */
void ConfigInitProc(HWND hDlg)
{
  GetIniEntries();
  GetIniSettings();
  SetDlgItemInt(hDlg, ID_SPEED,    wDrawSpeed,    FALSE);
  SetDlgItemInt(hDlg, ID_LENGTH,   wSerpentLength,   TRUE);
  SetDlgItemInt(hDlg, ID_CONTRAST, wContrastFactor,   TRUE);
  SetDlgItemInt(hDlg, ID_NUMLINES, wNumberOfLines,   TRUE);
  SendDlgItemMessage(hDlg, ID_PASSWORDPROTECTED, BM_SETCHECK,
                     bPassword, (int)NULL);
}


/* ------------------------------------------------------------------- */
/* OK Button pressed so get new settings and update, cleanup, and done */
/* ------------------------------------------------------------------- */
void ConfigOKProc(HWND hDlg)
{
  wDrawSpeed     = GetDlgItemInt(hDlg, ID_SPEED,    NULL, FALSE);
  wSerpentLength = GetDlgItemInt(hDlg, ID_LENGTH,   NULL, TRUE);
  wContrastFactor = GetDlgItemInt(hDlg, ID_CONTRAST, NULL, TRUE);
  wNumberOfLines  = GetDlgItemInt(hDlg, ID_NUMLINES, NULL, TRUE);
  bPassword  = IsDlgButtonChecked(hDlg, ID_PASSWORDPROTECTED);

  /* just use boundaries if out of range */
  if (wDrawSpeed < MINSPEED)
    wDrawSpeed = MINSPEED;

  if (wSerpentLength < MEMORYMIN)
    wSerpentLength  = MEMORYMIN;
  else if(wSerpentLength > MEMORYSIZE)
    wSerpentLength  = MEMORYSIZE;

  if (wContrastFactor > LOWCONTRAST)
    wContrastFactor = LOWCONTRAST;

  if (wNumberOfLines <  MINLINES)
    wNumberOfLines = MINLINES;
  else if (wNumberOfLines >  wSerpentLength)
    wNumberOfLines = wSerpentLength;

  WriteProfileInt(szAppName, szSpeedName, wDrawSpeed);
  WriteProfileInt(szAppName, szLengthName, wSerpentLength);
  WriteProfileInt(szAppName, szContrastName, wContrastFactor);
  WriteProfileInt(szAppName, szLinesName, wNumberOfLines);
  WriteProfileInt(szAppName, szIsPassword, bPassword);
  LocalHelpProc(hDlg, (WPARAM)NIL);

}


/* ------------------------------------------------------------------- */
/* GetIniSettings -- Get initial settings from WIN.INI                 */
/* ------------------------------------------------------------------- */
void GetIniSettings()
{
  wOldDrawSpeed     = wDrawSpeed;
  wOldSerpentLength = wSerpentLength;
  wOldColorContrast = wContrastFactor;
  wOldNumberOfLines = wNumberOfLines;

  wDrawSpeed     =
    GetPrivateProfileInt(szAppName, szSpeedName, wOldDrawSpeed, szIniFile);
  wSerpentLength =
    GetPrivateProfileInt(szAppName, szLengthName, wOldSerpentLength, szIniFile);
  wContrastFactor =
    GetPrivateProfileInt(szAppName, szContrastName, wOldColorContrast, szIniFile);
  wNumberOfLines =
    GetPrivateProfileInt(szAppName, szLinesName, wOldNumberOfLines, szIniFile);
  bPassword      =
    GetPrivateProfileInt(szAppName, szIsPassword, FALSE, szIniFile);

  wOldDrawSpeed     = wDrawSpeed;
  wOldSerpentLength = wSerpentLength;
  wOldColorContrast = wContrastFactor;
  wOldNumberOfLines = wNumberOfLines;
}


/* ------------------------------------------------------------------- */
/*                                                                     */
/* WriteProfileInt - Write an unsigned integer value to CONTROL.INI.   */
/*                                                                     */
/* Params:  name - szSection - [section] name in .INI file             */
/*                 szKey     - key= in .INI file                       */
/*                 i         - value for key above                     */
/*                                                                     */
/* Return:  None                                                       */
/* ------------------------------------------------------------------- */
void WriteProfileInt(LPSTR szSection, LPSTR szKey, int i)
{
  char achBuf[40];

  /* write out as unsigned because GetPrivateProfileInt()      */
  /* can't cope with signed values! (we expect unsigned also)  */

  wsprintf(achBuf, "%u", i);
  WritePrivateProfileString(szSection, szKey, achBuf, szIniFile);
}


/* ------------------------------------------------------------------- */
/* Load Common Strings from stringtable...                             */
/* ------------------------------------------------------------------- */
void GetIniEntries(void)
{

  LoadString(hMainInstance, idsIsPassword, szIsPassword, 22);
  LoadString(hMainInstance, idsIniFile, szIniFile, MAXFILELEN);
  LoadString(hMainInstance, idsScreenSaver, szScreenSaver, 22);
  LoadString(hMainInstance, idsPassword, szPassword, 16);
  LoadString(hMainInstance, idsDifferentPW, szDifferentPW, BUFFLEN);
  LoadString(hMainInstance, idsChangePW, szChangePW, 30);
  LoadString(hMainInstance, idsBadOldPW, szBadOldPW, 255);
  LoadString(hMainInstance, idsHelpFile, szHelpFile, MAXFILELEN);
  LoadString(hMainInstance, idsNoHelpMemory, szNoHelpMemory, BUFFLEN);
}


/* ------------------------------------------------------------------- */
/* RandomRange - standard c library call function                      */
/*   returns a random number in a usuable range  (1-MaxValue)          */
/* args                                                                */
/*   MaxValue - the highest number we want                             */
/*   bSeed    - seed the generator before getting random number        */
/* ------------------------------------------------------------------- */
int RandomRange(int iMaxValue, BOOL bSeed)
{
  int iRetVal;

  do {
    lWanderTime = (lWanderTime-1L); /* decrement global seed */
    while (lWanderTime < 2L) {      /* if below 1 reseed     */
      time(&lWanderTime);
       /* use timer to reset seed for random number generator */
      if (lWanderTime > 32767L)
       lWanderTime = lWanderTime%32767L; /* must be in a usable range */
    }
    if (bSeed == TRUE)
      srand((int)lWanderTime);  /* seed random number generator */
    iRetVal = rand();           /* get random number */

    /* get a non-zero value */
  } while(iRetVal < (NIL+1));

  /* use modulus of MaxValue if not in range */
  if (iRetVal > iMaxValue)
    iRetVal = (iRetVal%iMaxValue)+1;

  return iRetVal;               /* return a value in range */
}


/* ------------------------------------------------------------------- */
/* adjust - bounds processing                                          */
/*   called to test and reverse x or y term during plotting            */
/* ------------------------------------------------------------------- */
void Adjust(int *iPosition, int *iDelta, int iBoundMax)
{
  int iTest;

  iTest = *iPosition + *iDelta;
  if ((iTest < 1) || (iTest > iBoundMax)) {
    iTest = *iPosition;
    *iDelta = -*iDelta;
  }
  *iPosition = iTest;
}


/* ------------------------------------------------------------------- */
/* select new color                                                    */
/*   called at intervals during plotting to select another color       */
/* ------------------------------------------------------------------- */
void SelectNewColor()
{

  WORD wRed, wGreen, wBlue, wColor1, wColor2, wColor3, wSequence;

  /* -------------------------------------------------------------------- */
  /*  this strange contraption overcomes the tendency of too many         */
  /*    greyscale colors being used, since greys are not suitable for a   */
  /*    screensaver...                                                    */
  /*                                                                      */
  /*  effectively, I am bumping the rgb values by different methods to    */
  /*    limit the likelihood of all 3 being the same...                   */
  /*                                                                      */
  /*  after I bump the values, I am using a color sequence factor to      */
  /*    determine the dominant color and mapping the logical color to the */
  /*    appropriate color gun as determined by the sequence.              */
  /* -------------------------------------------------------------------- */

  /* ---------------------------------------------------------*/
  /* get logical random color values                          */
  /* 1. dominant - always something in this value             */
  /* ---------------------------------------------------------*/
  wColor1  = RandomRange(HIGHESTCOLOR, TRUE) + HIGHESTCOLOR;

  /* ---------------------------------------------------------*/
  /* 2. recessive - user definable contrast and if contrast   */
  /*    is not used this value will always be less than or    */
  /*    equal to Color1                                       */
  /* ---------------------------------------------------------*/
  wColor2  = RandomRange(HIGHESTCOLOR, FALSE) + wContrastFactor;

  /* ---------------------------------------------------------*/
  /* 3. variable - this value will either be nothing, or in   */
  /*    either dominant or recessive range depending on the   */
  /*    value of Color1 and on the contrast adjustment        */
  /* ---------------------------------------------------------*/
  wColor3  = RandomRange(HIGHESTCOLOR, FALSE) * (wColor1%3);
  wColor3  = ((wColor3 + wContrastFactor) & 255);

  /* use logical values to determine color mapping */
  wSequence = (wColor1+wColor2+wColor3)%6;

  /* --------------------------------------------------- */
  /* map logical color to color guns                     */
  /*  I have allowed for the 6 logical combinations here */
  /*    i.e. 123, 132, 231, 213, 321, 312                */
  /* --------------------------------------------------- */
  switch(wSequence) {
    case 0:
      wRed   = wColor1; wGreen = wColor2; wBlue  = wColor3;
      break;
    case 1:
      wRed   = wColor1; wBlue = wColor2;  wGreen = wColor3;
      break;
    case 2:
      wGreen = wColor1; wBlue  = wColor2; wRed   = wColor3;
      break;
    case 3:
      wGreen = wColor1; wRed   = wColor2; wBlue  = wColor3;
      break;
    case 4:
      wBlue  = wColor1; wRed   = wColor2; wGreen = wColor3;
      break;
    case 5:
      wBlue  = wColor1; wGreen = wColor2; wRed = wColor3;
      break;
  }

  /* build the color using the gun values */
  DrawColor = RGB(wRed, wGreen, wBlue);

  /* determine how long we will run this color before reselecting */
  iColorCount = (DELTAMULTIPLIER+1)*(1+RandomRange((DELTASEED+1), TRUE));
}


/* ------------------------------------------------------------------- */
/* select new delta values - for geometric fan effect                  */
/*   delta values are added during plotting to increment or decrement  */
/*   the end points on the lines to create a fan effect                */
/* ------------------------------------------------------------------- */
void SelectNewDeltaValues()
{
  iDeltaX1 = RandomRange(DELTAPLUS, TRUE)-DELTAMINUS;
  iDeltaY1 = RandomRange(DELTAPLUS, TRUE)-DELTAMINUS;
  iDeltaY2 = RandomRange(DELTAPLUS, TRUE)-DELTAMINUS;
  iDeltaX2 = RandomRange(DELTAPLUS, TRUE)-DELTAMINUS;

  /* the increment count controls how far each fan will travel */
  /* before it is replaced with a different geometry           */
  iIncrementCount = (DELTAMULTIPLIER)*(1+RandomRange(DELTASEED, TRUE));

}


/* ------------------------------------------------------------------- */
/* WriteLine at location and color specified                           */
/* ------------------------------------------------------------------- */
void WriteLine(HWND hWnd,
               UINT x1 , UINT y1, UINT x2, UINT y2, COLORREF TempColor)
{
  POINT pt;
  HPEN hPrevPen, hPen;

  if (x1 != x2 || y1 != y2) {
    /* try to save afew cyles by using a global black pen to erase lines */
    if (TempColor == 0L)
      hPen = hBlackPen;
    else
      hPen=CreatePen(PS_SOLID,1, TempColor);
    hPrevPen=SelectObject(hDC,hPen);
    MoveToEx(hDC,x1,y1,&pt);
    LineTo(hDC,x2,y2);
    SelectObject(hDC,hPrevPen);
    if (TempColor != 0L)
      DeleteObject(hPen);
  }
}


/* ------------------------------------------------------------------- */
/* wander the lines                                                    */
/* ------------------------------------------------------------------- */
void WanderingLines(HWND hWnd)
{

  WORD wCnt;

  BlankCheck(hWnd);

  for (wCnt = 0; wCnt < wNumberOfLines; wCnt++) {
      /* erase an old line (if any) before losing values     */
      /* the line array is a ring buffer using FIFO to erase */
      /*   the oldest line before drawing a new one          */
      WriteLine(hWnd,
              WanderLine[iCurrentLine].iLX1, WanderLine[iCurrentLine].iLY1,
              WanderLine[iCurrentLine].iLX2, WanderLine[iCurrentLine].iLY2, 0L);

    /* end of color term so select a new color */
    if (iColorCount < 1) SelectNewColor();

    /* end of shape so get new values for our geometry */
    if (iIncrementCount < 1) SelectNewDeltaValues();

    /* get values for the current line */
    /* if we have collided with the sides */
    /*   then change direction */

    Adjust(&iLX1, &iDeltaX1, rcWnd.right);
    Adjust(&iLY1, &iDeltaY1, rcWnd.bottom);
    Adjust(&iLX2, &iDeltaX2, rcWnd.right);
    Adjust(&iLY2, &iDeltaY2, rcWnd.bottom);

    /* -------------------------------------------------- */
    /* save the current line into the line structure      */
    /*   restored in black when required again            */
    /* -------------------------------------------------- */
    WanderLine[iCurrentLine].iLX1 = iLX1;
    WanderLine[iCurrentLine].iLY1 = iLY1;
    WanderLine[iCurrentLine].iLX2 = iLX2;
    WanderLine[iCurrentLine].iLY2 = iLY2;
    WanderLine[iCurrentLine].color = DrawColor;

    WriteLine(hWnd,
              WanderLine[iCurrentLine].iLX1, WanderLine[iCurrentLine].iLY1,
              WanderLine[iCurrentLine].iLX2, WanderLine[iCurrentLine].iLY2,
              WanderLine[iCurrentLine].color);

    /* get ready for the next pass... and increment and decrement
         animation counters as required */
    iCurrentLine++;
    if (iCurrentLine > (int)wSerpentLength)
      iCurrentLine = NIL;
    iColorCount--;
    iIncrementCount--;
  }
  return;
}


/* ------------------------------------------------------------------ */
/* if settings have changed or window was damaged reset the display   */
/* ------------------------------------------------------------------ */
void BlankCheck(HWND hWnd)
{
  int idx;

  if (bRefresh == TRUE) {
      if (wSerpentLength == wOldSerpentLength)
        for (idx = 0; idx < MEMORYMAX; idx++)
          WriteLine(hWnd,
                    WanderLine[idx].iLX1, WanderLine[idx].iLY1,
                    WanderLine[idx].iLX2, WanderLine[idx].iLY2,
                    WanderLine[idx].color);

    bRefresh = FALSE;
  }

  if (wSerpentLength != wOldSerpentLength)
    DoBlank(hWnd, TRUE);
}


/* ------------------------------------------------------------------ */
/* DoBlank                                                            */
/*   resets the animation                                             */
/* called on initialization or when the size of the serpent has       */
/*   been changed by the user.                                        */
/* ------------------------------------------------------------------ */
void DoBlank(HWND hWnd, BOOL bClear)
{ 
  int idx;

  /* zero-out previous line coordinates */
  /*  forces no erasing of previous shape in FIFO line ring buffer */
  for (idx = 0; idx < MEMORYMAX; idx++) {
    WanderLine[idx].color = 0L;
    if (bClear == TRUE)
      WriteLine(hWnd,
                WanderLine[idx].iLX1, WanderLine[idx].iLY1,
                WanderLine[idx].iLX2, WanderLine[idx].iLY2,
                WanderLine[idx].color);

    WanderLine[idx].iLX1 =
    WanderLine[idx].iLY1 =
    WanderLine[idx].iLX2 =
    WanderLine[idx].iLY2 = NIL;
  }

  lWanderTime   = 1L;       /* reset timer seed - forces initial seed */

  /* start somewhere new each time */
  iLX1 = iLY1 = iLX2 = iLY2 = RandomRange(rcWnd.bottom, TRUE);

  /* reset other values - forces initial selection */
  iColorCount = iIncrementCount = iCurrentLine = NIL;

  wOldSerpentLength = wSerpentLength;
  bRefresh = FALSE;                    /* reset refresh flags initially */
}
