/* VGAFAN.H - Header file for VGAFAN screen saver application.  */

#include <scrnsave.h>

#define ID_SPEED                    101
#define ID_LENGTH                   102
#define ID_CONTRAST                 103
#define ID_NUMLINES                 104
#define ID_LOCALHELP                105
#define ID_CONTEXTHELP              106
#define ID_GLOBALHELP               107
#define ID_PASSWORDPROTECTED        108
#define ID_SETPASSWORD              109
#define ID_HELP                     110

#define ID_TIMER 200

#define NIL             0
#define MEMORYSIZE      400
#define MEMORYMIN       100
#define MEMORYMEDIUM    300
#define MEMORYMAX       (MEMORYSIZE + 1)
#define HIGHESTCOLOR    127
#define HIGHCONTRAST    0
#define LOWCONTRAST     100
#define DELTAPLUS       16
#define DELTAMINUS      8
#define DELTAMULTIPLIER 8
#define DELTASEED       18
#define DRAWSPEED       5
#define MINSPEED        1
#define DEFLINES        2
#define MINLINES        1
#define IDH_MYCONTENTS  0L
#define IDH_MYSETUP     2001L

// Taken from Win32 SDK - additional info left for reference
//
//  NOTE:  The NetUI group is responsible for a number of applets
//         that are shipped with the base system.  This includes the
//         Network Control Panel Applet (NCPA.CPL), the Server Manager
//         and Services Applets (SRVMGR.CPL), and the UPS Applet (UPS.CPL).
//
//         To prevent help context conflicts between the NetUI applets
//         and the "standard" system applets, the NetUI group hereby
//         reserves the help contexts in the range 40000 - 59999.  This
//         will provide plenty of breathing room for future NetUI applets.
//

// note... these are passed as a DWORD value to WinHelp...

#define IDH_NETUI_FIRST 40000
#define IDH_NETUI_LAST  59999

#define IDH_HELPFIRST        5000
#define IDH_SCRNSAVE    (IDH_HELPFIRST + 4000)

// Screen Saver dialogs
#define IDH_DLG_CHANGEPASS      (IDH_SCRNSAVE)
#define IDH_DLG_MARQUE          (IDH_SCRNSAVE + 1)
#define IDH_DLG_MYSTIFY         (IDH_SCRNSAVE + 2)
#define IDH_DLG_STARSIM         (IDH_SCRNSAVE + 3)
#define IDH_DLG_MARQUEE_FONT    (IDH_SCRNSAVE + 4)
#define IDH_DLG_FLYWIN          (IDH_SCRNSAVE + 5)
#define IDH_DLG_BEZIER          (IDH_SCRNSAVE + 6)


/* Function prototypes */

int RandomRange(int, BOOL);
void Adjust(int *, int *, int);
void SelectNewColor(void);
void SelectNewDeltaValues(void);
void WriteLine(HWND, UINT, UINT, UINT, UINT, COLORREF);
void WanderingLines(HWND);
void BlankCheck(HWND);
void DoBlank(HWND, BOOL);
void GetIniEntries(void);
void GetIniSettings(void);
void WriteProfileInt(LPSTR key, LPSTR tag, int i);
void ConfigInitProc(HWND);
void ConfigOKProc(HWND);
void LocalHelpProc(HWND, WPARAM);
extern BOOL FAR PASCAL ScreenSaverConfigureDialog(HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam);
